<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Klinik Gigi  - Solusi Perawatan Gigi Anak dan Dewasa</title>
    <link rel="stylesheet" href="style_landing.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@500;600;700&display=swap" rel="stylesheet">
</head>
<body>

    <header class="navbar">
        <div class="container">
            <a href="#" class="logo">Klinik Tumbuh Kembang Pratama</a>
            <nav class="main-nav">
                <ul>
                    <li><a href="#layanan">Layanan</a></li>
                    <li><a href="#lokasi">Lokasi</a></li>
                    <li><a href="#artikel">Edukasi</a></li>
                </ul>
            </nav>
            <a href="index.php" class="btn-cta">Booking Sekarang</a>
        </div>
    </header>

    <main>
        <section class="hero">
            <div class="hero-container">
                <div class="hero-text">
                    <div class="badge">Selamat Datang di Klinik Gigi Anak!</div>
                    <h1>Periksa Gigi Jadi Menyenangkan!</h1>
                    <p>Kami menciptakan pengalaman periksa gigi yang positif dan bebas rasa takut untuk si kecil. Dokter kami sahabat anak-anak!</p>
                    <a href="index.php" class="btn-cta-primary">Buat Janji Temu Pertama si Kecil</a>
                </div>
                <div class="hero-image">
                    <img src="maskot.png" alt="Ilustrasi Dokter Gigi dan Anak">
                </div>
            </div>
        </section>

        <section id="layanan" class="services-section">
            <div class="container">
                <h2>Layanan</h2>
                <div class="services-grid">
                    <div class="service-card">
                        <div class="service-icon">🔎</div>
                        <h3>Pemeriksaan Rutin</h3>
                        <p>Mendeteksi masalah gigi sejak dini dengan cara yang asyik.</p>
                    </div>
                    <div class="service-card">
                        <div class="service-icon">🦷</div>
                        <h3>Penambalan Gigi</h3>
                        <p>Solusi untuk gigi berlubang dengan tambalan komposit sewarna gigi.</p>
                    </div>
                    <div class="service-card">
                        <div class="service-icon">✨</div>
                        <h3>Pembersihan Karang Gigi</h3>
                        <p>Bersihkan plak dan karang untuk nafas segar dan senyum sehat.</p>
                    </div>
                    <div class="service-card">
                        <div class="service-icon">🚀</div>
                        <h3>Konsultasi Tumbuh Kembang</h3>
                        <p>Pantau tumbuh kembang gigi dan rahang si kecil agar optimal.</p>
                    </div>
                </div>
            </div>
        </section>

        <section id="lokasi" class="lokasi-section">
            <div class="container">
                <h2>Temukan Kami di Sini!</h2>
                <div class="lokasi-grid">
                    <div class="lokasi-info">
                        <h3>Klinik Tumbuh Kembang Pratama</h3>
                        <p><strong>Alamat:</strong><br>Jl. Dokter Cipto No.181b, Karangturi, Kec. Semarang Tim., Kota Semarang, Jawa Tengah 50124</p>
                        <p><strong>Jam Buka:</strong><br>Senin - Sabtu<br>Pagi: 09.00 - 12.00<br>Sore: 16.00 - 20.00</p>
                    </div>
                    <div class="map-container">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3960.1316352722306!2d110.43372649999999!3d-6.993773699999999!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2e708ca240410bc7%3A0xe6db835f1b7f2b8!2sJalan%20Dokter%20Cipto%20No.181b%2C%20Karangturi%2C%20Kec.%20Semarang%20Tim.%2C%20Kota%20Semarang%2C%20Jawa%20Tengah%2050124!5e0!3m2!1sid!2sid!4v1761701842695!5m2!1sid!2sid" 
                        width="100%" 
                        height="350" 
                        style="border:0;" 
                        allowfullscreen="" 
                        loading="lazy" 
                        referrerpolicy="no-referrer-when-downgrade">
                    </iframe>
                </div>
                </div>
            </div>
        </section>
            
        <section id="artikel" class="artikel-section">
        <div class="container">
            <h2>Tips Jaga Kesehatan Gigi & Mulut</h2>
            
            <div class="artikel-grid">
                
                <div class="artikel-card">
                    <img src="sikat.png" alt="Menyikat gigi">
                    <div class="artikel-content">
                        <h4>Sikat Gigi 2x Sehari</h4>
                        <p>Wajib sikat gigi di pagi hari setelah sarapan dan malam hari sebelum tidur.</p>
                    </div>
                </div>
                
                <div class="artikel-card">
                    <img src="floss.png" alt="Benang gigi">
                    <div class="artikel-content">
                        <h4>Gunakan Benang Gigi (Flossing)</h4>
                        <p>Bersihkan sela-sela gigi yang tidak terjangkau sikat minimal sekali sehari.</p>
                    </div>
                </div>
                
                <div class="artikel-card">
                    <img src="periksa.png" alt="Periksa gigi rutin">
                    <div class="artikel-content">
                        <h4>Kontrol Rutin 6 Bulan Sekali</h4>
                        <p>Kunjungi dokter gigi untuk pemeriksaan dan pembersihan karang gigi.</p>
                    </div>
                </div>
                
                <div class="artikel-card">
                    <img src="makan.png" alt="Apel untuk gigi sehat">
                    <div class="artikel-content">
                        <h4>Batasi Makanan Manis & Asam</h4>
                        <p>Gula dan asam adalah musuh utama email gigi. Perbanyak minum air putih.</p>
                    </div>
                </div>
                
            </div>
        </div>
    </section>

    </main>

    <footer class="footer">
        <div class="container">
            <p>Klinik Tumbuh Kembang Pratama</p>
            <p>Solusi Perawatan Gigi Anak dan Dewasa</p>
        </div>
    </footer>

</body>
</html>