<?php
require 'config.php'; 
if (!isset($_SESSION['booking_sukses'])) {
    header("Location: dashboard.php");
    exit();
}

$data_booking = $_SESSION['booking_sukses'];
$nomor_antrian = htmlspecialchars($data_booking['nomor_antrian']);
$tanggal = htmlspecialchars($data_booking['tanggal']);
$jam = htmlspecialchars($data_booking['jam']);

unset($_SESSION['booking_sukses']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nomor Antrian Anda</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;700;900&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f4f7f6;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
            box-sizing: border-box;
        }
        .ticket-container {
            width: 100%;
            max-width: 500px;
            text-align: center;
        }
        .ticket-card {
            background-color: #e7eaf6;
            border-radius: 20px;
            padding: 20px 30px 40px 30px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }
        .ticket-header {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 15px;
            padding: 15px;
            border-bottom: 2px dashed #b5bad7;
            margin-bottom: 25px;
        }
        .clinic-info h1 {
            color: #00796b;
            font-size: 1.2rem;
            margin: 0;
            font-weight: 700;
        }
        .clinic-info p {
            color: #004d40;
            margin: 0;
            font-size: 0.9rem;
        }
        .tooth-icon {
            font-size: 2rem;
        }
        .ticket-body h2 {
            color: #333;
            font-size: 1.5rem;
            margin-top: 0;
            margin-bottom: 10px;
            font-weight: 400;
        }
        .queue-number {
            font-size: 8rem;
            font-weight: 900;
            color: #004d40;
            line-height: 1;
            margin: 10px 0;
        }
        .ticket-footer p {
            color: #555;
            font-size: 1rem;
            margin-top: 20px;
            line-height: 1.5;
        }
        .whatsapp-button {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            background-color: #25D366;
            color: white;
            padding: 15px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 700;
            margin-top: 30px;
            box-shadow: 0 4px 15px rgba(37, 211, 102, 0.4);
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .whatsapp-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 7px 20px rgba(37, 211, 102, 0.5);
        }
        .whatsapp-button svg {
            width: 24px;
            height: 24px;
        }
        .back-button {
            display: inline-block;
            margin-top: 15px;
            color: #00796b;
            text-decoration: none;
            font-weight: 600;
            padding: 8px 16px;
            border-radius: 20px;
            transition: background-color 0.2s;
        }
        .back-button:hover {
            background-color: #e0f2f1;
        }
    </style>
</head>
<body>

    <div class="ticket-container">
        <div class="ticket-card">
            <header class="ticket-header">
                <div class="tooth-icon">🦷</div>
                <div class="clinic-info">
                    <h1>TUMBUH KEMBANG PRATAMA</h1>
                    <p>Spesialis Gigi Anak</p>
                </div>
                <div class="tooth-icon">🦷</div>
            </header>
            
            <main class="ticket-body">
                <h2>Nomor Antrian Anda</h2>
                <div class="queue-number">
                    <?php echo $nomor_antrian; ?>
                </div>
            </main>

            <footer class="ticket-footer">
                <p>Harap datang sesuai jadwal Anda pada:<br><strong><?php echo $tanggal; ?> pukul <?php echo $jam; ?></strong></p>
            </footer>
        </div>
        
        <a href="https://wa.me/6281234567890?text=Halo,%20saya%20sudah%20berhasil%20booking%20dengan%20nomor%20antrian%20<?php echo $nomor_antrian; ?>" target="_blank" class="whatsapp-button">
            <svg viewBox="0 0 24 24" fill="currentColor"><path d="M16.75 13.96c.25.13.43.2.5.25.13.13.19.25.19.44 0 .25-.13.5-.25.63s-.25.25-.5.25c-.25 0-1.38-.19-2.88-1.13-1.5-.94-2.5-2.13-2.69-2.38-.13-.25-.25-.5-.25-.75s.13-.5.25-.63.25-.25.44-.25h.5c.19 0 .38.06.5.19.13.13.63.75.69.81.06.06.06.13 0 .19-.06.06-.13.13-.19.19s-.13.13-.19.19c-.06.06-.06.06 0 .13.06.06.25.38.56.69.31.31.69.56.75.63.13.06.19.06.25 0 .13-.06.38-.31.56-.5.19-.19.31-.38.44-.44.13-.06.25-.06.38 0m4.31-8.31C19.44 4.03 17.13 3 14.5 3 9.31 3 5.06 7.25 5.06 12.44c0 1.75.5 3.5 1.44 5.06l-1.5 5.5 5.63-1.5c1.5.88 3.19 1.38 4.88 1.38 5.19 0 9.44-4.25 9.44-9.44 0-2.63-1.06-4.94-2.69-6.56z"/></svg>
            Lanjutkan ke WhatsApp
        </a>

        <a href="dashboard.php" class="back-button">Kembali ke Dashboard</a>
        </div>

</body>
</html>