<?php
require 'config.php';

if (isset($_GET['sso_error']) && $_GET['sso_error'] === 'not_registered') {
    $error = "Akun Anda belum terdaftar. Silakan daftar terlebih dahulu.";
}

if (isset($_POST['signup'])) {
    $nama_lengkap = $_POST['nama_lengkap'];
    $email = $_POST['email'];
    $password = MD5($_POST['password']);
    $role = 'pelanggan';

    $query = $conn->prepare("INSERT INTO user (nama_lengkap, email, password, role) VALUES (?, ?, ?, ?)");
    $query->bind_param("ssss", $nama_lengkap, $email, $password, $role);
    
    if ($query->execute()) {
        $message = "Registrasi berhasil! Silakan login.";
    } else {
        $error = "Registrasi gagal, email mungkin sudah terdaftar.";
    }
}

if (isset($_POST['login'])) {
    $email = $_POST['email'];
    $password_input = $_POST['password'];

    $query = $conn->prepare("SELECT * FROM user WHERE email = ?");
    $query->bind_param("s", $email);
    $query->execute();
    $result = $query->get_result();

    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        
        if (md5($password_input) == $user['password'] || password_verify($password_input, $user['password'])) {
            if (!session_id()) {
                session_start();
            }
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_role'] = $user['role'];
            $_SESSION['user_nama'] = $user['nama_lengkap'];

            header("Location: dashboard.php");
            exit();
        }
    }
    
    $error = "Email atau password salah!";
}

$google_login_url = $google_client->createAuthUrl();

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Klinik Tumbuh Kembang Pratama - Selamat Datang!</title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Fredoka:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Fredoka', sans-serif; background: linear-gradient(-45deg, #FFD3D6, #FFE5E7, #F2E4F4, #E7DAF1); background-size: 400% 400%; animation: background-pan 25s ease infinite; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; color: #4A4A4A; }
        @keyframes background-pan { 0% { background-position: 0% 50%; } 50% { background-position: 100% 50%; } 100% { background-position: 0% 50%; } }
        .container { background-color: rgba(255, 255, 255, 0.9); backdrop-filter: blur(5px); padding: 40px; border-radius: 20px; box-shadow: 0 8px 32px 0 rgba(0,0,0,0.1); width: 90%; max-width: 400px; text-align: center; z-index: 10; }
        h2 { color: #6A5ACD; font-weight: 600; margin-bottom: 20px; }
        .form-container { position: relative; min-height: 380px; overflow: hidden; }
        form { position: absolute; width: 100%; transition: all 0.6s ease-in-out; }
        #loginForm { left: 0; }
        #signupForm { left: 100%; opacity: 0; }
        input { width: calc(100% - 24px); padding: 12px; margin: 10px 0; border: 2px solid #E3EAF2; border-radius: 15px; font-size: 16px; font-family: 'Fredoka', sans-serif; color: #4A4A4A; }
        input:focus { border-color: #C8CFEF; outline: none; box-shadow: 0 0 10px rgba(200, 207, 239, 0.5); }
        button { width: 100%; padding: 15px; border: none; background-color: #FFB0B5; color: white; border-radius: 50px; cursor: pointer; font-size: 18px; font-weight: 500; font-family: 'Fredoka', sans-serif; margin-top: 15px; transition: background-color 0.2s ease-in-out; }
        button:hover { background-color: #FFD3D6; }
        .toggle-link { margin-top: 20px; color: #6A5ACD; cursor: pointer; font-size: 14px; }
        .message { color: #2E7D32; font-weight: 500; margin-bottom: 15px; }
        .error { color: #D32F2F; font-weight: 500; margin-bottom: 15px; }
        .separator { display: flex; align-items: center; text-align: center; color: #aaa; margin: 25px 0 15px; }
        .separator::before, .separator::after { content: ''; flex: 1; border-bottom: 1px solid #ddd; }
        .separator:not(:empty)::before { margin-right: .25em; }
        .separator:not(:empty)::after { margin-left: .25em; }
        .google-login-button { display: inline-flex; align-items: center; justify-content: center; padding: 12px 20px; border: 2px solid #E3EAF2; border-radius: 50px; text-decoration: none; color: #4A4A4A; font-family: 'Fredoka', sans-serif; font-weight: 500; background-color: #fff; transition: all 0.2s; width: calc(100% - 44px); }
        .google-login-button:hover { border-color: #C8CFEF; box-shadow: 0 4px 12px rgba(0,0,0,0.08); }
        .google-login-button img { width: 20px; margin-right: 12px; }
    </style>
</head>
<body>
    <div class="container">
    <div id="logo">
        <img src="logo.png" alt="Logo Klinik" style="width: 150px; margin-bottom: 15px;">
    </div>
    
    <?php if (!empty($message)) echo "<p class='message'>$message</p>"; ?>
    <?php if (!empty($error)) echo "<p class='error'>$error</p>"; ?>

    <div class="form-container">
        <form id="loginForm" method="post" action="">
            <h2>Selamat Datang!</h2>
            <input type="email" name="email" placeholder="Email" required>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit" name="login">Masuk</button>

            <div class="separator">atau</div>
            <a href="<?= htmlspecialchars($google_login_url) ?>" class="google-login-button">
                <img src="https://developers.google.com/identity/images/g-logo.png" alt="Google logo">
                <span>Masuk dengan Google</span>
            </a>
        </form>

        <form id="signupForm" method="post" action="">
            <h2>Daftar Akun Baru</h2>
            <input type="text" name="nama_lengkap" placeholder="Nama Lengkap" required>
            <input type="email" name="email" placeholder="Email" required>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit" name="signup">Daftar</button>
        </form>
    </div>

    <p class="toggle-link" id="toggleToSignup">Belum punya akun? <span style="font-weight:600;">Daftar di sini!</span></p>
    <p class="toggle-link" id="toggleToLogin" style="display:none;">Sudah punya akun? <span style="font-weight:600;">Login di sini!</span></p>
</div>

    <script>
        const loginForm = document.getElementById('loginForm');
        const signupForm = document.getElementById('signupForm');
        const toggleToSignup = document.getElementById('toggleToSignup');
        const toggleToLogin = document.getElementById('toggleToLogin');
        toggleToSignup.addEventListener('click', () => { loginForm.style.left = "-100%"; loginForm.style.opacity = "0"; signupForm.style.left = "0"; signupForm.style.opacity = "1"; toggleToSignup.style.display = "none"; toggleToLogin.style.display = "block"; });
        toggleToLogin.addEventListener('click', () => { loginForm.style.left = "0"; loginForm.style.opacity = "1"; signupForm.style.left = "100%"; signupForm.style.opacity = "0"; toggleToSignup.style.display = "block"; toggleToLogin.style.display = "none"; });
    </script>
    
    <script>
        if (window.location.search.includes('sso_error=not_registered')) {
            const cleanUrl = window.location.protocol + "//" + window.location.host + window.location.pathname;
            
            window.history.replaceState({ path: cleanUrl }, '', cleanUrl);
        }
    </script>
</body>
</html>