<?php
require 'config.php';
if (isset($_GET['action']) && $_GET['action'] == 'get_booked_times') {
    header('Content-Type: application/json');
    $tanggal = $_GET['tanggal'] ?? date('Y-m-d');
    $jam_terisi = [];

    if ($stmt = $conn->prepare("SELECT jam_perjanjian FROM appointments WHERE tanggal_perjanjian = ?")) {
        $stmt->bind_param("s", $tanggal);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $jam_terisi[] = $row['jam_perjanjian'];
        }
        $stmt->close();
    }
    echo json_encode($jam_terisi);
    exit(); 
}

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

$user_id_login = $_SESSION['user_id'];
$role = $_SESSION['user_role'];
$nama_user = $_SESSION['user_nama'];

$body_class = '';
if ($role == 'pelanggan') {
    $body_class = 'kids-friendly';
}

$data_user = [];
if ($role == 'pelanggan') {
    $stmt_user = $conn->prepare("SELECT * FROM user WHERE id = ?");
    $stmt_user->bind_param("i", $user_id_login);
    $stmt_user->execute();
    $result_user = $stmt_user->get_result();
    $data_user = $result_user->fetch_assoc();
    $stmt_user->close();
}

$jam_praktek = ['09:00', '10:00', '11:00', '12:00', '13:00', '14:00', '15:00', '16:00'];

$jam_terisi_hari_ini = [];
$tanggal_hari_ini = date('Y-m-d');
$stmt_jam = $conn->prepare("SELECT jam_perjanjian FROM appointments WHERE tanggal_perjanjian = ?");
$stmt_jam->bind_param("s", $tanggal_hari_ini);
$stmt_jam->execute();
$result_jam = $stmt_jam->get_result();
while ($row = $result_jam->fetch_assoc()) {
    $jam_terisi_hari_ini[] = $row['jam_perjanjian'];
}
$stmt_jam->close();

$hasil_pencarian = [];
$nama_pasien_dicari = '';
if ($role == 'dokter' && isset($_GET['nama_pasien'])) {
    $nama_pasien_dicari = mysqli_real_escape_string($conn, $_GET['nama_pasien']);
    
    $query_cari = "SELECT u.nama_lengkap, a.tanggal_perjanjian, a.layanan, a.catatan_medis
                   FROM appointments a
                   JOIN user u ON a.id_pelanggan = u.id
                   WHERE a.id_dokter = ? AND u.nama_lengkap LIKE ?";
                   
    $stmt_cari = mysqli_prepare($conn, $query_cari);
    $search_term = "%" . $nama_pasien_dicari . "%";
    mysqli_stmt_bind_param($stmt_cari, "is", $user_id_login, $search_term);
    mysqli_stmt_execute($stmt_cari);
    $result_cari = mysqli_stmt_get_result($stmt_cari);
    while($row = mysqli_fetch_assoc($result_cari)){
        $hasil_pencarian[] = $row;
    }
    mysqli_stmt_close($stmt_cari);
}

$tanggal_dipilih = date('Y-m-d'); 

if ($role == 'admin' || $role == 'dokter') {
    if (isset($_GET['tanggal_antrian']) && !empty($_GET['tanggal_antrian'])) {
        if (DateTime::createFromFormat('Y-m-d', $_GET['tanggal_antrian']) !== false) {
            $tanggal_dipilih = $_GET['tanggal_antrian'];
        }
    }
}

$data_antrian_admin = [];
if ($role == 'admin')  {
    $query_antrian_admin = "
        SELECT 
            a.*, 
            u.nama_lengkap, 
            u.tanggal_lahir, 
            u.no_telepon 
        FROM appointments a
        JOIN user u ON a.id_pelanggan = u.id
        WHERE a.tanggal_perjanjian = ? 
        ORDER BY a.nomor_antrian ASC
    ";
    
    if ($stmt_antrian = $conn->prepare($query_antrian_admin)) {
        $stmt_antrian->bind_param("s", $tanggal_dipilih);
        $stmt_antrian->execute();
        $result_antrian = $stmt_antrian->get_result();
        $data_antrian_admin = $result_antrian->fetch_all(MYSQLI_ASSOC);
        $stmt_antrian->close();
    }
}

if (isset($_SESSION['notif'])) {
    $notif = $_SESSION['notif'];
    unset($_SESSION['notif']);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Dashboard - Klinik Tumbuh Kembang Pratama</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&family=Fredoka:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #eef1f5; margin: 0; padding: 0; }
        .header { background-color: #1a237e; color: white; padding: 15px 30px; display: flex; justify-content: space-between; align-items: center; }
        .header .header-info { text-align: center; flex-grow: 1; }
        .header .header-info h1 { margin: 0; font-size: 1.8em; }
        .header .header-info .alamat { margin: 5px 0 0 0; font-size: 0.9em; font-weight: 300; }
        .header .header-info .alamat a { color: white; text-decoration: none; }
        .header .header-info .alamat a:hover { text-decoration: underline; }
        .header .logout-link { color: #ffffff; text-decoration: none; font-weight: 600; }
        
        .container { padding: 30px; position: relative; z-index: 2; }
        .welcome-card { background-color: white; padding: 25px; border-radius: 10px; box-shadow: 0 4px 12px rgba(0,0,0,0.08); }
        
        h2, h3 { color: #1a237e; } 
        .tab-nav { border-bottom: 2px solid #eee; margin-bottom: 20px; }
        .tab-nav button { background-color: transparent; border: none; padding: 15px 20px; cursor: pointer; font-size: 16px; font-family: 'Poppins', sans-serif; color: #777; transition: all 0.3s; border-bottom: 3px solid transparent; }
        
        .tab-nav button.active { color: #1a237e; border-bottom: 3px solid #1a237e; font-weight: 600; } 
        .tab-content { display: none; }
        .tab-content.active { display: block; animation: fadeIn 0.5s; }
        .booking-form .form-group { margin-bottom: 15px; }
        .booking-form label { display: block; margin-bottom: 5px; font-weight: 600; color: #333; }
        .booking-form input, .booking-form select, .booking-form textarea { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; font-size: 15px; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        
        .booking-form button[type="submit"], .booking-form button.btn-cari { background-color: #4db6ac; color: white; padding: 12px 25px; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; margin-top: 10px; font-weight: 600; } 
        
        /* Table Styles Base */
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 12px; border: 1px solid #ddd; text-align: left; }
        th { background-color: #e3f2fd; color: #1a237e; white-space: nowrap; } 
        
        .table-responsive {
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
            margin-top: 20px;
            border: 1px solid #eee;
        }
        
        .notif { padding: 15px; margin-bottom: 20px; border-radius: 5px; color: white; }
        .notif.sukses { background-color: #4db6ac; } 
        .notif.gagal { background-color: #c62828; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
        
        #jam-grid-container, #jam-grid-container-admin { display: grid; grid-template-columns: repeat(auto-fit, minmax(90px, 1fr)); gap: 10px; margin-top: 5px; }
        .jam-button { padding: 12px 10px; border: 1px solid #ddd; border-radius: 5px; background-color: #fff; cursor: pointer; text-align: center; font-weight: 600; color: #333; transition: all 0.2s; }
        .jam-button:hover:not(:disabled) { border-color: #1a237e; color: #1a237e; } 
        .jam-button.selected { background-color: #1a237e; color: white; border-color: #1a237e; } 
        .jam-button:disabled { background-color: #e0e0e0; color: #aaa; cursor: not-allowed; border-color: #ccc; }
        
        .antrian-card { background-color: #ffffff; border: 1px solid #e0e0e0; border-left: 5px solid #1a237e; border-radius: 8px; padding: 20px; margin-bottom: 15px; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 2px 5px rgba(0,0,0,0.05); } 
        .antrian-info { text-align: left; }
        .antrian-info .tanggal { font-size: 1.2rem; font-weight: 600; color: #1a237e; }
        .antrian-info .dokter { font-size: 1rem; color: #555; margin-top: 5px; }
        .antrian-nomor { text-align: center; }
        .antrian-nomor span { display: block; font-size: 0.9rem; color: #777; }
        .antrian-nomor .nomor { font-size: 3rem; font-weight: 700; color: #1a237e; line-height: 1; }
        .no-antrian-msg { text-align: center; padding: 40px; background-color: #f9f9f9; border-radius: 8px; }
        
        .virus-container { display: grid; grid-template-columns: repeat(auto-fill, minmax(150px, 1fr)); gap: 20px; margin-top: 20px; }
        .virus-card { background-color: #e3f2fd; border: 2px solid #1a237e; border-radius: 10px; padding: 15px; text-align: center; cursor: pointer; transition: transform 0.2s, box-shadow 0.2s; }
        .virus-card:hover { transform: translateY(-5px); box-shadow: 0 8px 16px rgba(0,0,0,0.1); }
        .virus-card img { max-width: 80px; height: 80px; border-radius: 50%; margin-bottom: 10px; object-fit: cover; }
        .virus-card h4 { margin: 0; color: #1a237e; font-size: 1em; }
        
        .modal { display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; overflow: auto; background-color: rgba(0,0,0,0.6); justify-content: center; align-items: center; }
        .modal-content { background-color: #fefefe; margin: auto; padding: 30px; border: 1px solid #888; width: 80%; max-width: 600px; border-radius: 10px; position: relative; animation: fadeIn 0.5s; }
        .close-button { color: #aaa; position: absolute; top: 10px; right: 25px; font-size: 35px; font-weight: bold; }
        .close-button:hover, .close-button:focus { color: black; text-decoration: none; cursor: pointer; }
        .modal-content h2 { margin-top: 0; }
        .modal-content p { text-align: left; line-height: 1.6; margin-bottom: 15px; }
        .modal-content p strong { color: #4db6ac; display: block; margin-bottom: 5px; } 
        .fun-fact { background-color: #e3f2fd; border-left: 5px solid #4db6ac; padding: 15px; margin-top: 20px; border-radius: 5px; text-align: left; font-style: italic; } 
        
        .booking-details { background-color: #F2E4F4; border-radius: 15px; padding: 15px 20px; margin-top: 15px; text-align: left;}
        .booking-details p { margin: 10px 0; font-size: 1.1em; color: #4A4A4A;}
        .booking-details p strong { color: #6A5ACD;}
        
        .konsultasi-container { display: flex; flex-wrap: wrap; gap: 40px; align-items: center; background-color: #e3f2fd; padding: 30px; border-radius: 10px; margin-top: 20px;}
        .konsultasi-info { flex: 1 1 300px; }
        .konsultasi-info h3 { margin-top: 0; }
        .konsultasi-info p { color: #333; }
        .konsultasi-visual { flex: 0 0 150px; text-align: center; }
        .konsultasi-visual img { max-width: 120px; }
        .wa-button { display: inline-block; background-color: #25D366; color: white; padding: 15px 30px; border-radius: 8px; text-decoration: none; font-weight: 600; margin-top: 15px; transition: all 0.3s; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }
        .wa-button:hover { background-color: #128C7E; transform: translateY(-2px); box-shadow: 0 6px 12px rgba(0,0,0,0.15); }
        
        .faq-section { margin-top: 40px; }
        .faq-item { border-bottom: 1px solid #ddd; }
        .faq-question { padding: 18px 0; cursor: pointer; display: flex; justify-content: space-between; align-items: center; font-weight: 600; color: #1a237e; } 
        .faq-question::after { content: '+'; font-size: 1.5em; transition: transform 0.3s; }
        .faq-item.active .faq-question::after { transform: rotate(45deg); }
        .faq-answer { max-height: 0; overflow: hidden; transition: max-height 0.3s ease-out; background-color: #f9f9f9; padding: 0 20px; }
        .faq-answer p { margin: 0; padding: 20px 0; }
        .faq-item.active .faq-answer { max-height: 200px; padding: 0 20px; }
        
        .search-form-flex {
            display: flex; 
            gap: 10px; 
            align-items: center; 
            margin-bottom: 20px;
        }

        @keyframes kelinci-meloncat {
            0% { transform: translateY(0) rotate(0deg); }
            25% { transform: translateY(-15px) rotate(-5deg); }
            50% { transform: translateY(0) rotate(0deg); }
            75% { transform: translateY(-10px) rotate(5deg); }
            100% { transform: translateY(0) rotate(0deg); }
        }

        body.kids-friendly {
            font-family: 'Fredoka', sans-serif;
            background: linear-gradient(-45deg, #FFD3D6, #FFE5E7, #F2E4F4, #E7DAF1);
            background-size: 400% 400%;
            animation: background-pan 25s ease infinite;
            position: relative;
            overflow-x: hidden;
            color: #4A4A4A;
        }
        
        @keyframes background-pan { 0% { background-position: 0% 50%; } 50% { background-position: 100% 50%; } 100% { background-position: 0% 50%; } }

        .kids-friendly .header { background-color: #FFC6CA; color: white; box-shadow: 0 4px 10px rgba(255, 198, 202, 0.4);}
        .kids-friendly .header .header-info h1 { color: #4A4A4A; }
        .kids-friendly .welcome-card { background-color: rgba(255, 255, 255, 0.9); backdrop-filter: blur(3px); border: none; border-radius: 20px; box-shadow: 0 8px 32px 0 rgba(0,0,0,0.1); }
        .kids-friendly h2 { color: #6A5ACD; display: flex; align-items: center; }
        .kids-friendly h3 { color: #6A5ACD; }
        .kelinci-animasi { width: 80px; height: auto; margin-right: 15px; animation: kelinci-meloncat 2s ease-in-out infinite; }
        .kids-friendly .tab-nav { border-bottom: none; display: flex; gap: 15px; justify-content: center; }
        .kids-friendly .tab-nav button { border-bottom: none; border-radius: 50px; background-color: #FDDCE3; color: #6A5ACD; font-weight: 500; padding: 12px 25px; transition: background-color 0.3s ease, color 0.3s ease; }
        .kids-friendly .tab-nav button:hover { background-color: #D9BEE5; color: white; transform: none; box-shadow: none; }
        .kids-friendly .tab-nav button.active { background-color: #C8CFEF; color: white; transform: none; }
        .kids-friendly .booking-form label { color: #6A5ACD; font-weight: 500; }
        .kids-friendly .booking-form input, .kids-friendly .booking-form select, .kids-friendly .booking-form textarea { border: 2px solid #E3EAF2; border-radius: 15px; padding: 12px; color: #4A4A4A; }
        .kids-friendly .booking-form input:focus, .kids-friendly .booking-form select:focus, .kids-friendly .booking-form textarea:focus { border-color: #C8CFEF; outline: none; box-shadow: 0 0 10px rgba(200, 207, 239, 0.5); }
        .kids-friendly .booking-form button[type="submit"] { background-color: #FFB0B5; border-radius: 50px; padding: 15px 30px; font-size: 18px; font-family: 'Fredoka', sans-serif; border: none; color: white; transition: background-color 0.2s ease-in-out; animation: none; }
        .kids-friendly .booking-form button[type="submit"]:hover { background-color: #FFD3D6; transform: none; }
        .kids-friendly .jam-button { border-radius: 10px; border: 2px solid #E7DAF1; background-color: #fff; font-weight: 500; color: #6A5ACD; }
        .kids-friendly .jam-button:hover:not(:disabled) { border-color: #D9BEE5; color: #D9BEE5; }
        .kids-friendly .jam-button.selected { background-color: #A8ABDE; color: white; border-color: #A8ABDE; }
        .kids-friendly .antrian-card { background: linear-gradient(135deg, #F9DCC0, #F9E6E4); border: none; border-radius: 20px; color: #4A4A4A; box-shadow: 0 6px 15px rgba(249, 220, 192, 0.5); transition: background-color 0.3s ease; }
        .kids-friendly .antrian-card:hover { transform: none; background: linear-gradient(135deg, #F9E6E4, #F9DCC0); }
        .kids-friendly .antrian-info .tanggal { color: #6A5ACD; font-weight: 600; font-size: 1.4rem; }
        .kids-friendly .antrian-info .dokter { color: #8A8BA8; font-size: 1.1rem; }
        .kids-friendly .antrian-nomor span { color: #8A8BA8; font-size: 1rem; }
        .kids-friendly .antrian-nomor .nomor { color: #A8ABDE; font-size: 3.5rem; text-shadow: 1px 1px 2px rgba(0,0,0,0.05); }
        .kids-friendly .no-antrian-msg { background-color: #FDDCE3; border-radius: 20px; color: #6A5ACD; }
        .kids-friendly .virus-card { background-color: #F9E6E4; border: 2px solid #FFD3D6; border-radius: 20px; transition: background-color 0.3s ease, border-color 0.3s ease; }
        .kids-friendly .virus-card:hover { transform: none; box-shadow: 0 8px 16px rgba(255, 211, 214, 0.4); background-color: #FFE5E7; border-color: #FFC6CA; }
        .kids-friendly .virus-card h4 { color: #6A5ACD; font-weight: 600; }
        .kids-friendly .modal-content { border-radius: 20px; border: 5px solid #C8CFEF; background-color: #FEFBF6; color: #4A4A4A; }
        .kids-friendly .modal-content p strong { color: #A8ABDE; }
        .kids-friendly .fun-fact { background-color: #F2E4F4; border-left: 5px solid #D9BEE5; color: #6A5ACD; }
        .kids-friendly .konsultasi-container { background-color: #E7DAF1; border-radius: 20px; }
        .kids-friendly .konsultasi-info h3, .kids-friendly .konsultasi-info p { color: #4A4A4A; }
        .kids-friendly .wa-button { background-color: #C8CFEF; border-radius: 25px; }
        .kids-friendly .wa-button:hover { background-color: #A8ABDE; }
        .kids-friendly .faq-item { border-bottom: 2px dashed #E7DAF1; }
        .kids-friendly .faq-question { color: #6A5ACD; font-size: 1.1rem; }
        .kids-friendly .faq-question::after { content: '✨'; font-size: 1.5em; transition: transform 0.3s; }
        .kids-friendly .faq-item.active .faq-question::after { transform: rotate(360deg); }
        .kids-friendly .faq-answer { background-color: #F2E4F4; }
        
         @media (max-width: 768px) {
            .header {
                flex-direction: column; 
                padding: 15px;
                text-align: center;
            }
            .header .header-info h1 {
                font-size: 1.4em; 
            }
            .header .logout-link {
                margin-top: 10px; 
            }

            .container {
                padding: 15px;
            }

            .welcome-card {
                padding: 15px;
            }

            table {
                min-width: 600px; 
                font-size: 14px;
            }
            th, td {
                padding: 8px;
            }

            .tab-nav,
            .kids-friendly .tab-nav {
                justify-content: flex-start; 
                overflow-x: auto;         
                white-space: nowrap;       
                -webkit-overflow-scrolling: touch; 
                padding-bottom: 10px;     
            }
            .tab-nav button {
                font-size: 14px;
                padding: 10px 15px;
            }

            .search-form-flex {
                flex-direction: column;
                align-items: stretch; 
                gap: 15px;
            }
            .search-form-flex .form-group {
                width: 100%;
            }
            .search-form-flex button {
                width: 100%;
                margin-top: 5px;
            }
            .booking-form button[type="submit"], .booking-form button {
                width: 100%;
            }

            .antrian-card {
                flex-direction: column; 
                align-items: flex-start;
                padding: 15px;
            }
            .antrian-nomor {
                margin-top: 15px;
                align-self: center; 
                border-top: 1px dashed #ddd;
                padding-top: 10px;
                width: 100%;
            }
            .antrian-nomor .nomor {
                font-size: 2.5rem; 
            }
            .kids-friendly .antrian-nomor .nomor {
                font-size: 3rem;
            }

            .modal-content {
                width: 90%;
                padding: 20px;
            }

            .konsultasi-container {
                flex-direction: column;
                padding: 20px;
                text-align: center;
            }

            h2 { font-size: 1.5em; }
            .kids-friendly .antrian-info .tanggal { font-size: 1.2rem; }
        }
    </style>
</head>
<body class="<?php echo ($role == 'pelanggan') ? 'kids-friendly' : ''; ?>">
    
    <div id="bookingSuccessModal" class="modal" style="display: none;">
        <div class="modal-content kids-friendly" style="max-width: 450px; text-align: center;">
            <img src="https://i.ibb.co/L0Y0Vd4/success-icon.png" alt="Success" style="width: 100px; margin-bottom: 20px;">
            <h2 style="color: #6A5ACD;">Janji Temu Berhasil Dibuat!</h2>
            <p style="text-align: left; line-height: 1.8; font-size: 16px;">
                Berikut adalah detail janji temu Anda:
            </p>
            <div class="booking-details">
                <p><strong>Nomor Antrian:</strong> <span id="modalNomorAntrian"></span></p>
                <p><strong>Tanggal:</strong> <span id="modalTanggal"></span></p>
                <p><strong>Jam:</strong> <span id="modalJam"></span></p>
                <p><strong>Layanan:</strong> <span id="modalLayanan"></span></p>
            </div>
            <button id="closeModalBtn" class="wa-button" style="width: 100%; margin-top: 20px;">OK</button>
        </div>
    </div>

    <div class="header">
        <div class="header-info">
            <h1>Klinik Tumbuh Kembang Pratama</h1>
            <p class="alamat">
                <a href="https://www.google.com/maps/search/?api=1&query=Jalan+Dokter+Cipto+No.181b,+Karangturi,+Kec.+Semarang+Tim.,+Kota+Semarang,+Jawa+Tengah+50124" target="_blank">
                    Jalan Dokter Cipto No.181b, Karangturi, Kec. Semarang Tim., Kota Semarang, Jawa Tengah 50124
                </a>
            </p>
        </div>
        <a href="logout.php" class="logout-link">Logout</a>
    </div>

    <div class="container">
        <div class="welcome-card">
            <h2>
                <?php if ($role == 'pelanggan'): ?>
                    <img src="maskot.png" alt="Kelinci Gigi" class="kelinci-animasi">
                <?php endif; ?>
                Selamat Datang, <?php echo htmlspecialchars($nama_user); ?>!
            </h2>
            <hr>

            <?php
            if (isset($_SESSION['notif_sukses'])) {
                echo "<div class='notif sukses'>" . $_SESSION['notif_sukses'] . "</div>";
                unset($_SESSION['notif_sukses']);
            }
            if (isset($_SESSION['notif_gagal'])) {
                echo "<div class='notif gagal'>" . $_SESSION['notif_gagal'] . "</div>";
                unset($_SESSION['notif_gagal']);
            }
            
            
            ?>

            <?php if ($role == 'admin'): ?>
                <div class="tab-nav">
                    <button class="tab-link active" onclick="openTab(event, 'AntrianHariIni')">Daftar Antrian</button>
                    <button class="tab-link" onclick="openTab(event, 'BookingWalkIn')">Booking Pasien</button>
                    <button class="tab-link" onclick="openTab(event, 'DataPasien')">Data Pasien</button>
                </div>

                <div id="AntrianHariIni" class="tab-content active">
                <h3>Daftar Antrian untuk Tanggal: <?= htmlspecialchars(date('d F Y', strtotime($tanggal_dipilih))) ?></h3>
                    
                    <form action="dashboard.php" method="GET" class="booking-form search-form-flex">
                        <div class="form-group" style="flex-grow: 1; margin-bottom: 0;">
                            <label for="tanggal_antrian" style="margin-bottom: 0;">Pilih Tanggal:</label>
                            <input type="date" id="tanggal_antrian" name="tanggal_antrian" value="<?= htmlspecialchars($tanggal_dipilih) ?>">
                        </div>
                        <button type="submit" class="btn-cari" style="margin-top: 20px;">Cari</button>
                        <button id="tab-antrian" class="tab-link" onclick="openTab(event, 'AntrianHariIni')" style="display:none;"></button>
                    </form>

                    <div class="table-responsive">
                        <table>
                            <thead>
                                <tr>
                                    <th>No. Antrian</th>
                                    <th>Nama Pasien</th>
                                    <th>Jam</th>
                                    <th>Layanan</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query_antrian = "SELECT a.nomor_antrian, 
                                                         COALESCE(u.nama_lengkap, a.nama_pasien_walkin) AS nama_pasien, 
                                                         a.jam_perjanjian, a.layanan, a.status 
                                                  FROM appointments a 
                                                  LEFT JOIN user u ON a.id_pelanggan = u.id 
                                                  WHERE a.tanggal_perjanjian = ? 
                                                  ORDER BY a.nomor_antrian ASC";
                                $stmt_antrian = mysqli_prepare($conn, $query_antrian);
                                mysqli_stmt_bind_param($stmt_antrian, "s", $tanggal_dipilih);
                                mysqli_stmt_execute($stmt_antrian);
                                $result_antrian = mysqli_stmt_get_result($stmt_antrian);
                                
                                if (mysqli_num_rows($result_antrian) > 0) {
                                    while ($row = mysqli_fetch_assoc($result_antrian)) {
                                        echo "<tr>";
                                        echo "<td>" . htmlspecialchars(str_pad($row['nomor_antrian'], 3, '0', STR_PAD_LEFT)) . "</td>";
                                        echo "<td>" . htmlspecialchars($row['nama_pasien']) . "</td>"; 
                                        echo "<td>" . htmlspecialchars(date('H:i', strtotime($row['jam_perjanjian']))) . "</td>";
                                        echo "<td>" . htmlspecialchars($row['layanan']) . "</td>";
                                        echo "<td>" . ucfirst(htmlspecialchars($row['status'])) . "</td>";
                                        echo "</tr>";
                                    }
                                } else {
                                    echo "<tr><td colspan='5' style='text-align:center;'>Belum ada antrian pada tanggal ini.</td></tr>";
                                }
                                mysqli_stmt_close($stmt_antrian);
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div id="BookingWalkIn" class="tab-content">
                    <h3>Formulir Pendaftaran Pasien</h3>
                    <form action="admin_booking_process.php" method="POST" class="booking-form">
                        <div class="form-group"><label>Nama Lengkap</label><input type="text" name="nama_lengkap" required></div>
                        <div class="form-group"><label>Tanggal Lahir</label><input type="date" name="tanggal_lahir" required></div>
                        <div class="form-group"><label for="tgl_kunjungan_admin">Tanggal Kunjungan</label><input type="date" id="tgl_kunjungan_admin" name="tanggal_kunjungan" required min="<?= date('Y-m-d') ?>"></div>
                        <div class="form-group">
                            <label>Jam Kunjungan</label>
                            <div id="jam-grid-container-admin">
                                <?php foreach ($jam_praktek as $jam) : ?>
                                    <button type="button" class="jam-button" data-jam="<?= $jam ?>" <?= in_array($jam, $jam_terisi_hari_ini) ? 'disabled' : '' ?>>
                                        <?= $jam ?>
                                    </button>
                                <?php endforeach; ?>
                            </div>
                            <input type="hidden" name="jam_booking" id="jam_kunjungan_hidden_admin" required>
                        </div>
                        <div class="form-group"><label>Jenis Layanan</label><select name="layanan" required><option value="">-- Pilih Layanan --</option><option value="Pemeriksaan Rutin">Pemeriksaan Rutin</option><option value="Penambalan Gigi">Penambalan Gigi</option><option value="Pembersihan Karang Gigi">Pembersihan Karang Gigi</option><option value="Konsultasi Tumbuh Kembang">Konsultasi Tumbuh Kembang</option></select></div>
                        <div class="form-group"><label>Nomor Telepon</label><input type="tel" name="no_telepon"></div>
                        <div class="form-group"><label>Asal Sekolah</label><input type="text" name="sekolah"></div>
                        <div class="form-group"><label>Jenis Kelamin</label><select name="jenis_kelamin" required><option value="L">Laki-laki</option><option value="P">Perempuan</option></select></div>
                        <div class="form-group"><label>Alamat</label><textarea name="alamat" rows="3"></textarea></div>
                        <button type="submit">Daftarkan Pasien</button>
                    </form>
                </div>

                <div id="DataPasien" class="tab-content">
                    <h3>Database Pasien</h3>
                    <div class="table-responsive">
                        <table>
                            <thead>
                                <tr>
                                    <th>Nama Lengkap</th>
                                    <th>No. Telepon</th>
                                    <th>Tanggal Lahir</th>
                                    <th>Tanggal Kunjungan</th>
                                    <th>Layanan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query_riwayat = "
                                SELECT 
                                    a.tanggal_perjanjian,
                                    a.layanan,
                                    COALESCE(u.nama_lengkap, a.nama_pasien_walkin) AS nama_pasien,
                                    COALESCE(u.no_telepon, a.telepon_walkin) AS no_telepon,
                                    COALESCE(u.tanggal_lahir, a.tgl_lahir_walkin) AS tanggal_lahir
                                FROM 
                                    appointments a
                                LEFT JOIN 
                                    user u ON a.id_pelanggan = u.id
                                ORDER BY 
                                    a.tanggal_perjanjian DESC, a.id DESC
                            ";
                            $result_riwayat = mysqli_query($conn, $query_riwayat);
            
                            if (mysqli_num_rows($result_riwayat) > 0) {
                                while ($row = mysqli_fetch_assoc($result_riwayat)) {
                                    echo "<tr>";
                                    echo "<td>" . htmlspecialchars($row['nama_pasien']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['no_telepon'] ?? 'N/A') . "</td>";
                                    echo "<td>" . ($row['tanggal_lahir'] ? htmlspecialchars(date('d F Y', strtotime($row['tanggal_lahir']))) : 'N/A') . "</td>";
                                    echo "<td>" . htmlspecialchars(date('d F Y', strtotime($row['tanggal_perjanjian']))) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['layanan']) . "</td>";
                                    echo "</tr>";
                                }
                            } else {
                                echo "<tr><td colspan='5' style='text-align:center;'>Belum ada data kunjungan pasien.</td></tr>";
                            }
                            ?>
                        </tbody>
                        </table>
                    </div>
                </div>

            <?php elseif ($role == 'dokter'): 
            $tanggal_jadwal_dipilih = date("Y-m-d"); 
            if (isset($_GET['tanggal_jadwal']) && !empty($_GET['tanggal_jadwal'])) {
                if (DateTime::createFromFormat('Y-m-d', $_GET['tanggal_jadwal']) !== FALSE) {
                    $tanggal_jadwal_dipilih = $_GET['tanggal_jadwal'];
                }
            }
        ?>
            <div class="tab-nav">
                <button class="tab-link active" onclick="openTab(event, 'JadwalDokter')">Jadwal Pasien</button>
                <button class="tab-link" onclick="openTab(event, 'CariRekamMedis')">Cari Rekam Medis</button>
            </div>
            
            <div id="JadwalDokter" class="tab-content active">
                <h3>Jadwal Pasien untuk Tanggal: <?= htmlspecialchars(date('d F Y', strtotime($tanggal_jadwal_dipilih))) ?></h3>

                <form action="dashboard.php" method="GET" class="booking-form search-form-flex">
                    <div class="form-group" style="flex-grow: 1; margin-bottom: 0;">
                        <label for="tanggal_jadwal" style="margin-bottom: 0;">Pilih Tanggal:</label>
                        <input type="date" id="tanggal_jadwal" name="tanggal_jadwal" value="<?= htmlspecialchars($tanggal_jadwal_dipilih) ?>">
                    </div>
                    <button type="submit" class="btn-cari">Cari</button>
                    <button id="tab-jadwal" class="tab-link" onclick="openTab(event, 'JadwalDokter')" style="display:none;"></button>
                </form>

                <div class="table-responsive">
                    <table>
                        <thead>
                            <tr>
                                <th>Antrian</th>
                                <th>Nama Pasien</th>
                                <th>Jam</th>
                                <th>Layanan</th>
                                <th>Catatan Medis</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $query_jadwal = "
                            SELECT 
                                a.id, 
                                a.nomor_antrian, 
                                COALESCE(u.nama_lengkap, a.nama_pasien_walkin) AS nama_pasien, 
                                a.jam_perjanjian, 
                                a.layanan, 
                                a.catatan_medis 
                            FROM 
                                appointments a 
                            LEFT JOIN 
                                user u ON a.id_pelanggan = u.id 
                            WHERE 
                                a.id_dokter = ? AND a.tanggal_perjanjian = ? 
                            ORDER BY 
                                a.nomor_antrian ASC
                        ";
                        
                        $stmt_jadwal = mysqli_prepare($conn, $query_jadwal);
                        mysqli_stmt_bind_param($stmt_jadwal, "is", $user_id_login, $tanggal_jadwal_dipilih);
                        mysqli_stmt_execute($stmt_jadwal);
                        $result_jadwal = mysqli_stmt_get_result($stmt_jadwal);
                    
                        if (mysqli_num_rows($result_jadwal) > 0) {
                            while ($row = mysqli_fetch_assoc($result_jadwal)) {
                                echo "<tr>";
                                echo "<td>" . htmlspecialchars($row['nomor_antrian']) . "</td>";
                                echo "<td>" . htmlspecialchars($row['nama_pasien']) . "</td>"; 
                                echo "<td>" . date('H:i', strtotime($row['jam_perjanjian'])) . "</td>";
                                echo "<td>" . htmlspecialchars($row['layanan']) . "</td>";
                                echo "<td><form action='update_catatan.php' method='POST' class='booking-form' style='margin-top:0;'><input type='hidden' name='appointment_id' value='" . $row['id'] . "'><textarea name='catatan_medis' rows='2' style='min-width: 150px;'>" . htmlspecialchars($row['catatan_medis']) . "</textarea></td>";
                                echo "<td><button type='submit' style='width: auto; margin-top: 5px;'>Simpan</button></form></td>";
                                echo "</tr>";
                            }
                        } else {
                            echo "<tr><td colspan='6' style='text-align:center;'>Tidak ada jadwal pasien untuk tanggal yang dipilih.</td></tr>";
                        }
                        mysqli_stmt_close($stmt_jadwal);
                        ?>
                    </tbody>
                    </table>
                </div>
            </div>
            
            <div id="CariRekamMedis" class="tab-content">
                <h3>Cari Rekam Medis Pasien</h3>
                <form action="dashboard.php" method="GET" class="booking-form search-form-flex">
                    <input type="hidden" name="tab" value="CariRekamMedis">
                    <div class="form-group" style="flex-grow: 1; margin-bottom: 0;">
                        <label for="nama_pasien_search" style="margin-bottom: 0;">Masukkan Nama Pasien:</label>
                        <input type="text" id="nama_pasien_search" name="nama_pasien_search" placeholder="Ketik nama pasien..." value="<?= htmlspecialchars($_GET['nama_pasien_search'] ?? '') ?>" required>
                    </div>
                    <button type="submit" class="btn-cari">Cari</button>
                </form>
            
                <?php
                // Cek hanya jika ada input pencarian
                if (isset($_GET['nama_pasien_search']) && !empty(trim($_GET['nama_pasien_search']))) {
                    $nama_pasien_dicari = '%' . $_GET['nama_pasien_search'] . '%';
                ?>
                    <h4>Hasil Pencarian untuk: "<?= htmlspecialchars($_GET['nama_pasien_search']) ?>"</h4>
                    <div class="table-responsive">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>Nama Pasien</th>
                                    <th>Tanggal Kunjungan</th>
                                    <th>Layanan</th>
                                    <th>Dokter</th>
                                    <th>Catatan Medis</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query_rekam_medis = "
                                    SELECT 
                                        COALESCE(u.nama_lengkap, a.nama_pasien_walkin) AS nama_pasien,
                                        a.tanggal_perjanjian,
                                        a.layanan,
                                        d.nama_lengkap AS nama_dokter,
                                        a.catatan_medis
                                    FROM 
                                        appointments a
                                    LEFT JOIN 
                                        user u ON a.id_pelanggan = u.id
                                    JOIN
                                        user d ON a.id_dokter = d.id AND d.role = 'dokter'
                                    WHERE 
                                        (u.nama_lengkap LIKE ? OR a.nama_pasien_walkin LIKE ?)
                                    ORDER BY 
                                        a.tanggal_perjanjian DESC
                                ";
            
                                $stmt_rekam_medis = mysqli_prepare($conn, $query_rekam_medis);
                                if ($stmt_rekam_medis) {
                                    mysqli_stmt_bind_param($stmt_rekam_medis, "ss", $nama_pasien_dicari, $nama_pasien_dicari);
                                    mysqli_stmt_execute($stmt_rekam_medis);
                                    $result_rekam_medis = mysqli_stmt_get_result($stmt_rekam_medis);
            
                                    if (mysqli_num_rows($result_rekam_medis) > 0) {
                                        while ($rekam = mysqli_fetch_assoc($result_rekam_medis)) {
                                            echo "<tr>";
                                            echo "<td>" . htmlspecialchars($rekam['nama_pasien']) . "</td>";
                                            echo "<td>" . htmlspecialchars(date('d F Y', strtotime($rekam['tanggal_perjanjian']))) . "</td>";
                                            echo "<td>" . htmlspecialchars($rekam['layanan']) . "</td>";
                                            echo "<td>" . htmlspecialchars($rekam['nama_dokter']) . "</td>";
                                            echo "<td>" . htmlspecialchars($rekam['catatan_medis']) . "</td>";
                                            echo "</tr>";
                                        }
                                    } else {
                                        echo "<tr><td colspan='5' style='text-align:center;'>Data rekam medis tidak ditemukan.</td></tr>";
                                    }
                                    mysqli_stmt_close($stmt_rekam_medis);
                                } else {
                                    echo "<tr><td colspan='5' style='text-align:center;'>Terjadi kesalahan pada query.</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                <?php
                } 
                ?>
            </div>
            
            <?php elseif ($role == 'pelanggan'): ?>
                <div class="tab-nav">
                    <button class="tab-link active" onclick="openTab(event, 'BookingSaya')">Booking</button>
                    <button class="tab-link" onclick="openTab(event, 'AntrianSaya')">Antrian Saya</button>
                    <button class="tab-link" onclick="openTab(event, 'Edukasi')">Edukasi</button>
                    <button class="tab-link" onclick="openTab(event, 'Konsultasi')">Konsultasi</button>
                </div>

                <div id="BookingSaya" class="tab-content active">
                    <h3>Formulir Booking Janji Temu</h3>
                    <p>Silakan lengkapi data di bawah ini</p>
                    
                    <?php
                    if (isset($_SESSION['booking_gagal'])) {
                        echo "<div class='notif gagal'>" . $_SESSION['booking_gagal'] . "</div>";
                        unset($_SESSION['booking_gagal']);
                    }
                    ?>

                    <form action="booking_process.php" method="POST" class="booking-form">
                        <input type="hidden" name="id_pelanggan" value="<?= htmlspecialchars($user_id_login) ?>">
                        <div class="form-group"><label for="nama_pelanggan">Nama Lengkap</label><input type="text" id="nama_pelanggan" name="nama_lengkap" value="<?= htmlspecialchars($data_user['nama_lengkap'] ?? '') ?>" required></div>
                        <div class="form-group"><label for="tgl_lahir_pelanggan">Tanggal Lahir</label><input type="date" id="tgl_lahir_pelanggan" name="tanggal_lahir" value="<?= htmlspecialchars($data_user['tanggal_lahir'] ?? '') ?>" required></div>
                        <div class="form-group"><label for="tgl_kunjungan_pelanggan">Tanggal Kunjungan</label><input type="date" id="tgl_kunjungan_pelanggan" name="tanggal_kunjungan" required min="<?= date('Y-m-d') ?>"></div>
                        <div class="form-group">
                            <label>Pilih Jam Kunjungan</label>
                            <div id="jam-grid-container"></div>
                            <input type="hidden" id="jam_kunjungan_terpilih" name="jam_kunjungan" required>
                        </div>
                        <div class="form-group"><label for="jenis_layanan">Jenis Layanan</label><select id="jenis_layanan" name="jenis_layanan" required><option value="">-- Pilih Layanan --</option><option value="Pemeriksaan Rutin">Pemeriksaan Rutin</option><option value="Penambalan Gigi">Penambalan Gigi</option><option value="Pembersihan Karang Gigi">Pembersihan Karang Gigi</option><option value="Konsultasi Tumbuh Kembang">Konsultasi Tumbuh Kembang</option></select></div>
                        <div class="form-group"><label for="telp_pelanggan">Nomor Telepon</label><input type="tel" id="telp_pelanggan" name="no_telepon" value="<?= htmlspecialchars($data_user['no_telepon'] ?? '') ?>" required></div>
                        <div class="form-group"><label for="alamat_pelanggan">Alamat</label><textarea id="alamat_pelanggan" name="alamat" rows="3" required><?= htmlspecialchars($data_user['alamat'] ?? '') ?></textarea></div>
                        <div class="form-group"><label for="sekolah_pelanggan">Asal Sekolah</label><input type="text" id="sekolah_pelanggan" name="sekolah" value="<?= htmlspecialchars($data_user['sekolah'] ?? '') ?>"></div>
                        <div class="form-group"><label for="jk_pelanggan">Jenis Kelamin</label><select id="jk_pelanggan" name="jenis_kelamin" required><option value="L" <?= ($data_user['jenis_kelamin'] ?? '') == 'L' ? 'selected' : '' ?>>Laki-laki</option><option value="P" <?= ($data_user['jenis_kelamin'] ?? '') == 'P' ? 'selected' : '' ?>>Perempuan</option></select></div>
                        <button type="submit">Booking Sekarang!</button>
                    </form>
                </div>

                <div id="AntrianSaya" class="tab-content">
                    <h3>Jadwal Janji Temu Kamu</h3>
                    <?php
                    $query_antrian_saya = "SELECT apt.id, apt.nomor_antrian, apt.tanggal_perjanjian, apt.jam_perjanjian, apt.status, u_dokter.nama_lengkap AS nama_dokter
                       FROM appointments AS apt
                       JOIN user AS u_dokter ON apt.id_dokter = u_dokter.id
                       WHERE apt.id_pelanggan = ? 
                       AND apt.tanggal_perjanjian >= CURDATE()
                       AND apt.status != 'dibatalkan'
                       ORDER BY apt.tanggal_perjanjian ASC, apt.jam_perjanjian ASC";
                    
                    $stmt_antrian_saya = mysqli_prepare($conn, $query_antrian_saya);
                    mysqli_stmt_bind_param($stmt_antrian_saya, "i", $user_id_login);
                    mysqli_stmt_execute($stmt_antrian_saya);
                    $result_antrian_saya = mysqli_stmt_get_result($stmt_antrian_saya);

                    if (mysqli_num_rows($result_antrian_saya) > 0) {
                    while($antrian = mysqli_fetch_assoc($result_antrian_saya)) {
                        $tanggal_formatted = date('l, d F Y', strtotime($antrian['tanggal_perjanjian']));
                        $jam_formatted = date('H:i', strtotime($antrian['jam_perjanjian'])); 
                        $nomor_antrian_formatted = str_pad($antrian['nomor_antrian'], 3, '0', STR_PAD_LEFT);
                        
                        $is_cancelable = ($antrian['tanggal_perjanjian'] > date('Y-m-d'));
                    ?>
                        <div class="antrian-card">
                            <div class="antrian-info">
                                <div class="tanggal"><?php echo $tanggal_formatted; ?> - Jam <?php echo $jam_formatted; ?></div>
                                <div class="dokter">Dokter: <?php echo htmlspecialchars($antrian['nama_dokter']); ?></div>
                                
                                <?php if ($is_cancelable): ?>
                                    <form action="cancel_appointment.php" method="POST" onsubmit="return confirm('Apakah Anda yakin ingin membatalkan janji ini?');" style="margin-top: 10px;">
                                        <input type="hidden" name="id_appointment" value="<?php echo $antrian['id']; ?>">
                                        
                                        <button type="submit" class="btn-cancel" style="background-color: #ef5350; color: white; border: none; padding: 5px 10px; border-radius: 5px; cursor: pointer; font-size: 0.9em;">
                                            Cancel Appointment
                                        </button>
                                    </form>
                                <?php endif; ?>
                                </div>
                            <div class="antrian-nomor">
                                <span>No. Antrian</span>
                                <div class="nomor"><?php echo $nomor_antrian_formatted; ?></div>
                            </div>
                        </div>
                    <?php
                        }
                    } else {
                        echo "<div class='no-antrian-msg'><p>Kamu belum punya jadwal janji temu, lho. Yuk, buat sekarang!</p></div>";
                    }
                    mysqli_stmt_close($stmt_antrian_saya);
                    ?>
                </div>

                <div id="Edukasi" class="tab-content">
                    <h3>Ayo Kenali Teman-Teman di Mulut Kita!</h3>
                    <p>Beberapa di antaranya nakal dan bisa menyebabkan masalah. Yuk, kenalan sama mereka!</p>

                    <div class="virus-container">
                        <div class="virus-card" data-virus="mutans"><img src="/IBD/Virus/S.Mutans.jpg" alt="Bakteri S.Mutans"><h4>S. Mutans</h4></div>
                        <div class="virus-card" data-virus="gingivitis"><img src="/IBD/Virus/Gingivitis.jpg" alt="Bakteri Gingivitis"><h4>Gingivitis</h4></div>
                        <div class="virus-card" data-virus="kalkulus"><img src="/IBD/Virus/Kalkulus.jpg" alt="Kalkulus si Karang Gigi"><h4>Kalkulus (Karang Gigi)</h4></div>
                        <div class="virus-card" data-virus="caries"><img src="/IBD/Virus/Caries.jpg" alt="Karies Gigi"><h4>Karies (Gigi Berlubang)</h4></div>
                        <div class="virus-card" data-virus="plak"><img src="/IBD/Virus/Plak.jpg" alt="Plak Gigi"><h4>Plak</h4></div>
                        <div class="virus-card" data-virus="debris"><img src="/IBD/Virus/Debris.jpg" alt="Debris Makanan"><h4>Debris (Sisa Makanan)</h4></div>
                        <div class="virus-card" data-virus="halitosis"><img src="/IBD/Virus/Halitosis.jpg" alt="Bau Mulut"><h4>Halitosis (Bau Mulut)</h4></div>
                        <div class="virus-card" data-virus="stomatitis"><img src="/IBD/Virus/Stomatitis.jpg" alt="Sariawan"><h4>Stomatitis (Sariawan)</h4></div>
                        <div class="virus-card" data-virus="herpes"><img src="/IBD/Virus/Herpes.jpg" alt="Virus Herpes"><h4>Herpes Mulut</h4></div>
                        <div class="virus-card" data-virus="candida"><img src="/IBD/Virus/Candida Albicans.jpg" alt="Jamur Candida Albicans"><h4>Candida Albicans</h4></div>
                        <div class="virus-card" data-virus="actinomyces"><img src="/IBD/Virus/Actinomyces Viscosus.jpg" alt="Bakteri Actinomyces"><h4>Actinomyces Viscosus</h4></div>
                        <div class="virus-card" data-virus="nocardia"><img src="/IBD/Virus/Nocardia.jpg" alt="Bakteri Nocardia"><h4>Nocardia</h4></div>
                    </div>

                    <div id="virusModal" class="modal">
                        <div class="modal-content">
                            <span class="close-button">×</span>
                            <h2 id="modalVirusName"></h2>
                            <p><strong>Siapa dia?</strong><span id="modalVirusDescription"></span></p>
                            <p><strong>Apa penyebabnya?</strong><span id="modalVirusCauses"></span></p>
                            <p><strong>Bagaimana cara mengatasinya?</strong><span id="modalVirusPrevention"></span></p>
                            <div class="fun-fact" id="modalFunFact"></div>
                        </div>
                    </div>
                </div>

                <div id="Konsultasi" class="tab-content">
                    <div class="konsultasi-container">
                        <div class="konsultasi-visual">
                            <img src="https://cdn-icons-png.flaticon.com/512/3063/3063233.png" alt="Konsultasi Dokter">
                        </div>
                        <div class="konsultasi-info">
                             <h3>Punya Pertanyaan Seputar Kesehatan Gigi?</h3>
                             <p>Jangan ragu untuk bertanya. Tim dokter kami siap membantu menjawab pertanyaan Kamu dan memberikan solusi terbaik. Klik tombol di bawah untuk memulai percakapan.</p>
                             <a href="https://wa.me/6281234567890" target="_blank" class="wa-button">Mulai Konsultasi via WhatsApp</a>
                        </div>
                    </div>
                    
                    <div class="faq-section">
                        <h3>Pertanyaan Umum (FAQ)</h3>
                        <div class="faq-item">
                            <div class="faq-question">Kapan waktu terbaik untuk sikat gigi?</div>
                            <div class="faq-answer"><p>Waktu terbaik untuk menyikat gigi adalah setelah sarapan di pagi hari dan sebelum tidur di malam hari. Pastikan Kamu menyikat selama minimal 2 menit ya!</p></div>
                        </div>
                        <div class="faq-item">
                            <div class="faq-question">Apakah scaling atau pembersihan karang gigi itu sakit?</div>
                            <div class="faq-answer"><p>Umumnya tidak sakit, tapi beberapa orang mungkin merasakan sedikit ngilu atau tidak nyaman, seperti digelitik. Dokter akan melakukannya dengan hati-hati sekali untuk meminimalkan rasa tidak nyaman.</p></div>
                        </div>
                        <div class="faq-item">
                            <div class="faq-question">Berapa kali aku harus periksa gigi ke dokter?</div>
                            <div class="faq-answer"><p>Dianjurkan untuk melakukan pemeriksaan gigi rutin setiap 6 bulan sekali. Ini bertujuan agar dokter bisa menemukan kalau ada masalah gigi dan mulut sejak dini.</p></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
    function openTab(evt, tabName) {
        let i, tabcontent, tablinks;
        tabcontent = document.getElementsByClassName("tab-content");
        for (i = 0; i < tabcontent.length; i++) { tabcontent[i].style.display = "none"; tabcontent[i].className = tabcontent[i].className.replace(" active", ""); }
        tablinks = document.getElementsByClassName("tab-link");
        for (i = 0; i < tablinks.length; i++) { tablinks[i].className = tablinks[i].className.replace(" active", ""); }
        document.getElementById(tabName).style.display = "block";
        document.getElementById(tabName).style.animation = 'fadeIn 0.5s ease-out';
        if(evt) {
            evt.currentTarget.className += " active";
        }
    }

    function setupBookingGrid(inputTanggalId, jamContainerId, inputJamTerpilihId, role) {
        const inputTanggal = document.getElementById(inputTanggalId);
        if (!inputTanggal) return; 

        const jamContainer = document.getElementById(jamContainerId);
        const inputJamTerpilih = document.getElementById(inputJamTerpilihId);
        
        let jamButtons;

        if (role === 'pelanggan') {
            const jamTersedia = ['09:00', '10:00', '11:00', '12:00', '16:00', '17:00', '18:00', '19:00', '20:00'];
            jamContainer.innerHTML = '';
            jamTersedia.forEach(jam => {
                const button = document.createElement('button');
                button.type = 'button';
                button.className = 'jam-button';
                button.dataset.jam = jam;
                button.textContent = jam;
                jamContainer.appendChild(button);
            });
            jamButtons = jamContainer.querySelectorAll('.jam-button');
        } 
        else if (role === 'admin') {
            jamButtons = jamContainer.querySelectorAll('.jam-button');
        }
        
        if (!jamButtons || jamButtons.length === 0) return;

        jamButtons.forEach(button => {
            button.addEventListener('click', function() {
                jamButtons.forEach(btn => btn.classList.remove('selected'));
                this.classList.add('selected');
                inputJamTerpilih.value = this.dataset.jam;
            });
        });

        async function periksaJadwal() {
            const tanggalDipilih = inputTanggal.value;
            inputJamTerpilih.value = ''; 
            jamButtons.forEach(btn => btn.classList.remove('selected'));

            jamButtons.forEach(btn => {
                btn.disabled = !tanggalDipilih; 
            });
            
            if (!tanggalDipilih) return;

            try {
                let jamTerisi = [];
                
                if (role === 'admin') {
                    const response = await fetch(`dashboard.php?action=get_booked_times&tanggal=${tanggalDipilih}`);
                    jamTerisi = await response.json();
                    
                } else if (role === 'pelanggan') {
                    const formData = new FormData();
                    formData.append('tanggal_kunjungan', tanggalDipilih);
                    const response = await fetch('cek_jadwal.php', { method: 'POST', body: formData });
                    const data = await response.json();
                    jamTerisi = data.map(j => j.substring(0, 5));
                }

                jamButtons.forEach(button => {
                    const jam = button.dataset.jam;
                    if (jamTerisi.includes(jam)) {
                        button.disabled = true;
                    } else {
                        button.disabled = false;
                    }
                });
            } catch (error) {
                console.error('Error saat memeriksa jadwal:', error);
            }
        }

        inputTanggal.addEventListener('change', periksaJadwal);
        periksaJadwal();
    }
    

    function setupEdukasi() {
        const virusContainer = document.querySelector('.virus-container');
        if (!virusContainer) return;

        const virusData = {
            mutans: { name: "Streptococcus Mutans", description: "Ini adalah bakteri super kecil yang paling suka tinggal di mulutmu. Dia adalah pemimpin geng penyebab gigi berlubang!", causes: "Dia suka sekali makan sisa-sisa makanan manis yang kamu makan. Setelah makan, dia mengeluarkan zat asam yang bisa melubangi gigimu.", prevention: "Sikat gigi dua kali sehari dengan pasta gigi berfluoride, kurangi makan makanan manis dan rajin periksa ke dokter gigi!", funFact: "S. Mutans bisa membuat 'rumah' lengket di gigimu yang disebut plak. Itulah kenapa gigimu terasa kasar kalau tidak disikat!" },
            gingivitis: { name: "Bakteri Gingivitis", description: "Bakteri ini suka berkumpul di gusi. Kalau mereka terlalu banyak, gusimu bisa jadi merah, bengkak, dan mudah berdarah saat sikat gigi.", causes: "Gingivitis muncul kalau plak (rumah bakteri) di gigi tidak dibersihkan. Mereka akan mengganggu gusimu dan membuatnya meradang.", prevention: "Sikat gigi dengan benar sampai ke bagian gusi, dan gunakan benang gigi (dental floss) setiap hari untuk membersihkan sela-sela gigi.", funFact: "Gingivitis adalah tahap awal penyakit gusi. Kalau kita rajin membersihkan gigi, gusi kita bisa sehat kembali!" },
            kalkulus: { name: "Kalkulus (Karang Gigi)", description: "Kalkulus sebenarnya bukan bakteri, tapi dia adalah plak (rumah bakteri) yang sudah mengeras seperti batu. Dia sangat keras dan menempel erat di gigi.", causes: "Dia terbentuk ketika plak tidak dibersihkan dalam waktu lama. Mineral dari air liur kita membuatnya mengeras. Warnanya bisa kuning atau coklat.", prevention: "Hanya dokter gigi yang bisa membersihkan kalkulus dengan alat khusus. Untuk mencegahnya datang kembali, sikat gigi dan gunakan benang gigi secara teratur!", funFact: "Kalkulus juga sering disebut 'tartar'. Dia bisa membuat nafas jadi tidak sedap, lho!" },
            caries: { name: "Karies (Gigi Berlubang)", description: "Ini adalah kerusakan pada gigi yang disebabkan oleh asam dari bakteri. Kalau dibiarkan, bisa membuat lubang kecil yang makin lama makin besar.", causes: "Bakteri di mulut mengubah sisa makanan manis (gula) menjadi asam. Asam inilah yang menggerogoti lapisan luar gigi (email) dan membuatnya jadi berlubang.", prevention: "Sikat gigi dua kali sehari dengan pasta gigi berfluoride, kurangi makanan manis, dan rutin periksa ke dokter gigi setiap 6 bulan sekali.", funFact: "Gigi berlubang tidak bisa sembuh sendiri, lho! Makanya harus ditambal oleh dokter gigi agar tidak makin parah." },
            plak: { name: "Plak", description: "Plak adalah lapisan lengket dan tidak berwarna yang penuh dengan bakteri. Plak selalu terbentuk di gigi kita setiap hari.", causes: "Plak terbentuk ketika bakteri di mulut berkembang biak dari sisa makanan, terutama yang mengandung gula dan pati.", prevention: "Sikat gigi secara teratur dan gunakan benang gigi (dental floss) setiap hari. Plak yang tidak dibersihkan bisa mengeras menjadi karang gigi.", funFact: "Kamu bisa merasakan plak saat bangun tidur di pagi hari. Gigimu terasa sedikit kasar dan tidak licin!" },
            debris: { name: "Debris (Sisa Makanan)", description: "Debris adalah sisa-sisa makanan yang menempel di sela-sela gigi setelah kita makan.", causes: "Setiap kali kita makan, pasti ada sisa makanan yang tertinggal, terutama makanan yang berserat seperti daging atau jagung.", prevention: "Bersihkan sela-sela gigi dengan benang gigi atau sikat interdental setelah makan. Berkumur dengan air juga bisa membantu.", funFact: "Debris adalah makanan favorit bagi bakteri penyebab gigi berlubang. Jangan biarkan mereka berpesta di mulutmu, ya!" },
            halitosis: { name: "Halitosis (Bau Mulut)", description: "Ini adalah kondisi ketika nafas kita mengeluarkan bau yang tidak sedap.", causes: "Penyebab utamanya adalah bakteri yang memecah sisa makanan di mulut dan lidah, lalu menghasilkan gas berbau. Bisa juga karena mulut kering.", prevention: "Sikat gigi dan lidah secara teratur, minum air putih yang cukup agar mulut tidak kering, dan hindari makanan berbau tajam seperti bawang.", funFact: "Bau mulut di pagi hari itu wajar, karena saat tidur, produksi air liur kita berkurang sehingga bakteri lebih mudah berkembang." },
            stomatitis: { name: "Stomatitis (Sariawan)", description: "Sariawan adalah luka kecil berbentuk bulat atau oval yang terasa perih di dalam mulut, seperti di pipi, bibir, atau lidah.", causes: "Penyebabnya banyak, bisa karena tidak sengaja tergigit, kekurangan vitamin, stres, atau alergi makanan.", prevention: "Jaga kebersihan mulut, makan makanan bergizi seimbang (terutama yang kaya vitamin C dan B12), dan hindari makanan yang terlalu pedas atau asam.", funFact: "Sariawan biasanya akan sembuh sendiri dalam waktu 1-2 minggu. Tapi kalau sangat sakit, ada obat oles khusus yang bisa membantu." },
            herpes: { name: "Herpes Mulut", description: "Ini adalah infeksi yang disebabkan oleh virus Herpes Simplex (HSV-1). Biasanya muncul sebagai luka melepuh kecil di sekitar bibir atau mulut.", causes: "Virus ini sangat menular dan bisa menyebar melalui kontak langsung, seperti berbagi peralatan makan dengan orang yang terinfeksi.", prevention: "Hindari kontak langsung dengan luka herpes orang lain. Jaga daya tahan tubuh agar tetap kuat, karena virus ini suka muncul saat tubuh kita sedang lelah.", funFact: "Sekali terinfeksi, virus herpes akan 'tidur' di dalam tubuh kita selamanya dan bisa 'bangun' lagi kapan saja." },
            candida: { name: "Candida Albicans", description: "Ini adalah jamur yang sebenarnya normal ada di mulut kita. Tapi kalau berkembang biak terlalu banyak, bisa menyebabkan infeksi.", causes: "Infeksi jamur ini sering terjadi pada bayi, orang yang memakai gigi palsu, atau orang dengan daya tahan tubuh yang lemah. Terlihat seperti lapisan putih di lidah.", prevention: "Jaga kebersihan mulut dan gigi palsu dengan baik. Untuk bayi, sterilkan botol susu dan dot secara teratur.", funFact: "Infeksi Candida di mulut juga sering disebut 'oral thrush'." },
            actinomyces: { name: "Actinomyces Viscosus", description: "Ini adalah salah satu bakteri 'pionir' yang pertama kali menempel di gigi untuk membentuk plak.", causes: "Bakteri ini adalah bagian normal dari kumpulan bakteri di mulut kita dan berperan dalam tahap awal pembentukan plak gigi.", prevention: "Sama seperti mencegah plak, yaitu dengan menyikat gigi dan menggunakan benang gigi secara rutin untuk mengangkat lapisan bakteri ini.", funFact: "Meskipun namanya 'actinomyces', bakteri ini bukan jamur (myces), lho! Dia murni bakteri." },
            nocardia: { name: "Nocardia", description: "Ini adalah jenis bakteri lain yang juga ditemukan dalam plak gigi, meskipun jumlahnya tidak sebanyak bakteri lain.", causes: "Nocardia adalah bagian dari ekosistem kompleks bakteri di dalam mulut kita dan ikut berkontribusi dalam pembentukan plak.", prevention: "Menjaga kebersihan mulut secara menyeluruh adalah cara terbaik untuk mengontrol pertumbuhan semua jenis bakteri plak, termasuk Nocardia.", funFact: "Bakteri Nocardia lebih sering menyebabkan masalah pada paru-paru daripada di mulut, tapi mereka tetap menjadi penghuni plak gigi." }
        };

        const virusCards = document.querySelectorAll('.virus-card');
        const modal = document.getElementById('virusModal');
        
        if (!modal || virusCards.length === 0) {
            console.error("Elemen untuk edukasi tidak ditemukan.");
            return;
        }

        const closeButton = modal.querySelector('.close-button');
        const modalVirusName = document.getElementById('modalVirusName');
        const modalVirusDescription = document.getElementById('modalVirusDescription');
        const modalVirusCauses = document.getElementById('modalVirusCauses');
        const modalVirusPrevention = document.getElementById('modalVirusPrevention');
        const modalFunFact = document.getElementById('modalFunFact');

        virusCards.forEach(card => {
            card.addEventListener('click', () => {
                const virusType = card.dataset.virus;
                const data = virusData[virusType];
                if (data) {
                    modalVirusName.textContent = data.name;
                    modalVirusDescription.textContent = data.description;
                    modalVirusCauses.textContent = data.causes;
                    modalVirusPrevention.textContent = data.prevention;
                    modalFunFact.textContent = "Fakta Seru: " + data.funFact;
                    modal.style.display = 'flex';
                }
            });
        });

        closeButton.addEventListener('click', () => { modal.style.display = 'none'; });
        window.addEventListener('click', (event) => { if (event.target == modal) { modal.style.display = 'none'; } });
    }

    function setupFAQ() {
        const faqItems = document.querySelectorAll('.faq-item');
        faqItems.forEach(item => {
            const question = item.querySelector('.faq-question');
            question.addEventListener('click', () => {
                const currentlyActive = document.querySelector('.faq-item.active');
                if (currentlyActive && currentlyActive !== item) {
                    currentlyActive.classList.remove('active');
                }
                item.classList.toggle('active');
            });
        });
    }

        document.addEventListener('DOMContentLoaded', function() {
            // Bagian setup awal Anda (biarkan seperti semula)
            const userRole = "<?php echo $role; ?>";
            if (userRole === 'pelanggan') {
                setupBookingGrid('tgl_kunjungan_pelanggan', 'jam-grid-container', 'jam_kunjungan_terpilih', 'pelanggan');
                setupEdukasi();
            } else if (userRole === 'admin') {
                setupBookingGrid('tgl_kunjungan_admin', 'jam-grid-container-admin', 'jam_kunjungan_hidden_admin', 'admin');
            }
            setupFAQ();
        
            const urlParams = new URLSearchParams(window.location.search);
            
            const tabToOpen = urlParams.get('tab');
            const searchedPatient = urlParams.get('nama_pasien_search'); 
            const searchedAntrian = urlParams.get('tanggal_antrian');
            const searchedJadwal = urlParams.get('tanggal_jadwal');
        
            let targetTabId = null;
        
            if (tabToOpen) {
                targetTabId = tabToOpen;
            } else if (searchedPatient) {
                targetTabId = 'CariRekamMedis';
            } else if (searchedAntrian) {
                targetTabId = 'AntrianHariIni';
            } else if (searchedJadwal) {
                targetTabId = 'JadwalDokter';
            }
        
            if (targetTabId) {
                openTab(null, targetTabId);
                const tabButton = document.querySelector('button[onclick*="' + targetTabId + '"]');
                if (tabButton) {
                    tabButton.classList.add('active');
                }
            } else {
                const firstVisibleTab = document.querySelector('.tab-nav button:not([style*="display:none"]).tab-link');
                if (firstVisibleTab) {
                    firstVisibleTab.click();
                } else {
                    document.querySelector('.tab-link').click();
                }
            }
        });
</script>
</body>
</html>