<?php
// cancel_appointment.php
session_start();
require 'config.php';

// Cek login
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] != 'pelanggan') {
    header("Location: index.php");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['id_appointment'])) {
    $id_appointment = $_POST['id_appointment'];
    $id_pelanggan = $_SESSION['user_id'];
    $tanggal_hari_ini = date('Y-m-d');

    // 1. Ambil data janji temu untuk verifikasi tanggal dan kepemilikan
    $stmt = $conn->prepare("SELECT tanggal_perjanjian FROM appointments WHERE id = ? AND id_pelanggan = ?");
    $stmt->bind_param("ii", $id_appointment, $id_pelanggan);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        $tanggal_janji = $row['tanggal_perjanjian'];

        // 2. Cek apakah masih H-1 (Tanggal Janji harus lebih besar dari Hari Ini)
        // Jika Hari Ini = 2023-11-20, Janji = 2023-11-21 (Besok). Maka 2023-11-21 > 2023-11-20 (TRUE -> Boleh Cancel)
        // Jika Hari Ini = 2023-11-20, Janji = 2023-11-20 (Hari H). Maka 2023-11-20 > 2023-11-20 (FALSE -> Tidak Boleh)
        
        if ($tanggal_janji > $tanggal_hari_ini) {
            
            // Lakukan Pembatalan (Update Status menjadi 'dibatalkan')
            $update_stmt = $conn->prepare("UPDATE appointments SET status = 'dibatalkan' WHERE id = ?");
            $update_stmt->bind_param("i", $id_appointment);
            
            if ($update_stmt->execute()) {
                $_SESSION['notif'] = "Janji temu berhasil dibatalkan.";
            } else {
                $_SESSION['notif'] = "Gagal membatalkan janji temu.";
            }
            $update_stmt->close();
            
        } else {
            $_SESSION['notif'] = "Pembatalan gagal. Hanya bisa cancel maksimal H-1.";
        }
    } else {
        $_SESSION['notif'] = "Data janji temu tidak ditemukan.";
    }
    $stmt->close();
}

// Kembali ke dashboard
header("Location: dashboard.php");
exit();
?>