<?php
// booking_process.php (VERSI FINAL)

require 'config.php'; // Memanggil $conn dari file di atas

if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] != 'pelanggan') {
    header("Location: index.php");
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $id_pelanggan = $_SESSION['user_id'];
    
    $nama_lengkap = $_POST['nama_lengkap'] ?? '';
    $tanggal_lahir = $_POST['tanggal_lahir'] ?? null;
    $no_telepon = $_POST['no_telepon'] ?? '';
    $alamat = $_POST['alamat'] ?? '';
    $sekolah = $_POST['sekolah'] ?? '';
    $jenis_kelamin = $_POST['jenis_kelamin'] ?? '';
    
    $tanggal_kunjungan = $_POST['tanggal_kunjungan'] ?? '';
    $jam_kunjungan = $_POST['jam_kunjungan'] ?? '';
    $jenis_layanan = $_POST['jenis_layanan'] ?? '';
    $id_dokter = $_POST['id_dokter'] ?? 2;

    $query_update_user = $conn->prepare(
        "UPDATE user SET 
            nama_lengkap = ?, tanggal_lahir = ?, no_telepon = ?, 
            alamat = ?, sekolah = ?, jenis_kelamin = ? 
        WHERE id = ?"
    );
    $query_update_user->bind_param("ssssssi", $nama_lengkap, $tanggal_lahir, $no_telepon, $alamat, $sekolah, $jenis_kelamin, $id_pelanggan);
    $query_update_user->execute();
    $query_update_user->close();
    
    $nomor_antrian_baru = 1;
    $query_antrian = $conn->prepare("SELECT MAX(nomor_antrian) AS antrian_terakhir FROM appointments WHERE tanggal_perjanjian = ?");
    $query_antrian->bind_param("s", $tanggal_kunjungan);
    $query_antrian->execute();
    $result_antrian = $query_antrian->get_result();
    $data_antrian = $result_antrian->fetch_assoc();
    if ($data_antrian && $data_antrian['antrian_terakhir']) {
        $nomor_antrian_baru = $data_antrian['antrian_terakhir'] + 1;
    }
    $query_antrian->close();

    $query_insert_appt = $conn->prepare(
        "INSERT INTO appointments (id_pelanggan, id_dokter, tanggal_perjanjian, jam_perjanjian, nomor_antrian, layanan, status) 
         VALUES (?, ?, ?, ?, ?, ?, 'dijadwalkan')"
    );
    $query_insert_appt->bind_param("iissis", $id_pelanggan, $id_dokter, $tanggal_kunjungan, $jam_kunjungan, $nomor_antrian_baru, $jenis_layanan);
    
    if ($query_insert_appt->execute()) {
        $_SESSION['booking_sukses'] = [
            'nomor_antrian' => str_pad($nomor_antrian_baru, 3, '0', STR_PAD_LEFT),
            'tanggal'       => date('d F Y', strtotime($tanggal_kunjungan)),
            'jam'           => $jam_kunjungan,
            'layanan'       => $jenis_layanan
        ];
        header("Location: dashboard.php?status=sukses#AntrianSaya");
        exit();
    } else {
        $_SESSION['booking_gagal'] = "Terjadi kesalahan pada database: " . $conn->error;
        header("Location: dashboard.php?status=gagal#Booking");
        exit();
    }
    $query_insert_appt->close();
}
?>